 ; Ŀ
 ;   Irg - selective entity regen.                                         
 ;   Copyright 1994, 2006 by Rocket Software Ltd.                          
 ;   For those who have seen enough square circles.                        
 ; 

 ; Ŀ
 ;   Subroutine Cruns: returns the coordinates of the corners of the       
 ;   current display area.                                                 
 ; 
 (DEFUN CRUNS (/ ra a vs ctr w maxx minx maxy miny aa bb cc dd)
  (setq a (getvar "screensize"))           ; view height & width (pixels)
  (setq a (/ (car a) (cadr a)))            ; view width/height ratio
  (setq vs (* (getvar "viewsize") 0.5))    ; view height in drawing units
  (setq ctr (getvar "viewctr"))            ; centre point of screen
  (setq w (* vs a ))                       ; view half width
  (setq maxx (+ (car ctr) w))
  (setq minx (- (car ctr) w))
  (setq maxy (+ (cadr ctr) vs))
  (setq miny (- (cadr ctr) vs))
  (setq ll (list minx miny))
  (setq ul (list minx maxy))
  (setq ur (list maxx maxy))
  (setq lr (list maxx miny))
;  (grdraw ll ul 7 1)
;  (grdraw ul ur 7 1)
;  (grdraw ur lr 7 1)
;  (grdraw lr ll 7 1)
 (list ll ul ur lr))
 ; Ŀ
 ;   Cruns end.                                                            
 ; 

 ; Ŀ
 ;   Screeg - get an ss of everything on the screen.                       
 ; 
 (DEFUN SCREEG (/ corner aa cc)
  (setq corner (cruns))
  (setq aa (car corner))
  (setq cc (caddr corner))
  (ssget "c" aa cc))
 ; Ŀ
 ;   Screeg end.                                                           
 ; 

 ; Ŀ
 ;   Irg.                                                                  
 ; 
 (DEFUN C:IRG (/ num ss enam)
  (cond ((= 4 (logand 4 (getvar "cmdactive"))) ; during a script
         (setq ss (screeg)))
        ((and (write-line "Select entities or <Return> for current screen: ")
              (setq ss (ssget))))
        (t (setq ss (screeg))))
  (setq num 0)
  (if ss
     (while (setq enam (ssname ss num))
            (entmod (entget enam))
            (setq num (1+ num))))
 (princ))